<?php
$TOKEN = "8138986181:AAFOGkDNM3rXBHKQnCHCfJRcIg4oueQRE5E";
$API_URL = "https://api.telegram.org/bot$TOKEN/";
$folder_gambar = __DIR__ . "/img/"; // Folder img/ berisi 1.jpeg sampai 7.jpeg
$log_file = __DIR__ . "/user_log.json";

// Load log user
$user_log = file_exists($log_file) ? json_decode(file_get_contents($log_file), true) : [];

$update = json_decode(file_get_contents("php://input"), true);

// Handle message (username input)
if(isset($update["message"])){
    $chat_id = $update["message"]["chat"]["id"];
    $text = trim($update["message"]["text"]);

    if(isset($user_log[$chat_id]['await_username']) && $user_log[$chat_id]['await_username']){
        // Simpan username baru
        $user_log[$chat_id]['username'] = $text;
        $user_log[$chat_id]['await_username'] = false;
        file_put_contents($log_file, json_encode($user_log));

        kirimPesan($chat_id, "✅ Username berhasil disimpan: *{$text}*\nSekarang klik Mahjong 1/2 untuk melihat prediksi.");
        kirimMenu($chat_id);
        exit;
    }

    if($text == "/start"){
        kirimMenu($chat_id);
    }
}

// Handle callback query
if(isset($update["callback_query"])){
    $callback = $update["callback_query"];
    $chat_id = $callback["message"]["chat"]["id"];
    $data = $callback["data"];

    switch($data){
        case "aturan":
            $pesan = "📜 ATURAN MAIN

⚠️ Untuk memastikan bot berjalan lancar tanpa gangguan serta hasil tetap akurat 100%, wajib menggunakan link khusus bot.

🔗 Akses hanya melalui: https://kilat128a.pro/avzr";
            kirimPesan($chat_id, $pesan);
            break;

        case "mahjong1":
        case "mahjong2":
            if(!isset($user_log[$chat_id]['username'])){
                $user_log[$chat_id]['await_username'] = true;
                file_put_contents($log_file, json_encode($user_log));
                kirimPesan($chat_id, "📝 Silakan masukkan *username* Anda terlebih dahulu:");
            } else {
                $now = time();
                $user_log[$chat_id]['last_click'] = $now;
                file_put_contents($log_file, json_encode($user_log));

                kirimGambarAcak($chat_id, $user_log[$chat_id]['username']);
                kirimRefreshButton($chat_id);
                kirimUbahUsernameButton($chat_id);
            }
            break;

        case "refresh":
            $now = time();
            if(isset($user_log[$chat_id]['last_click'])){
                $diff = $now - $user_log[$chat_id]['last_click'];
                if($diff >= 10800){ // 3 jam
                    $user_log[$chat_id]['last_click'] = $now;
                    file_put_contents($log_file, json_encode($user_log));

                    $username = $user_log[$chat_id]['username'] ?? "User";
                    kirimGambarAcak($chat_id, $username);
                } else {
                    $menit = ceil((10800 - $diff)/60);
                    kirimPesan($chat_id, "⚠️ Refresh baru bisa digunakan setelah $menit menit lagi.");
                }
            } else {
                kirimPesan($chat_id, "⚠️ Silakan klik Mahjong 1/2 terlebih dahulu.");
            }
            break;

        case "ubah_username":
            $user_log[$chat_id]['await_username'] = true;
            file_put_contents($log_file, json_encode($user_log));
            kirimPesan($chat_id, "📝 Silakan masukkan *username baru* Anda:");
            break;
    }

    // Hapus loading
    file_get_contents($API_URL . "answerCallbackQuery?" . http_build_query([
        "callback_query_id" => $callback["id"]
    ]));
}

// Fungsi kirim menu utama
function kirimMenu($chat_id){
    global $API_URL;
    $inline_keyboard = [
        "inline_keyboard" => [
            [["text" => "ATURAN MAIN", "callback_data" => "aturan"]],
            [["text" => "MAHJONG 1", "callback_data" => "mahjong1"]],
            [["text" => "MAHJONG 2", "callback_data" => "mahjong2"]],
            [["text" => "Ubah Username", "callback_data" => "ubah_username"]]
        ]
    ];
    $reply = [
        "chat_id" => $chat_id,
        "text" => "Selamat datang di Bot Mahjong 🎲\nSilakan pilih menu:",
        "reply_markup" => json_encode($inline_keyboard)
    ];
    file_get_contents($API_URL . "sendMessage?" . http_build_query($reply));
}

// Fungsi kirim gambar acak 3–5 dengan username
function kirimGambarAcak($chat_id, $username){
    global $folder_gambar;

    $files = glob($folder_gambar . "*.jpeg");
    if(count($files) > 0){
        $seed = intval(date("YmdH"));
        srand($seed);

        $jumlah_gambar = rand(3,5);
        $pilihan = [];
        while(count($pilihan) < $jumlah_gambar){
            $index = rand(0, count($files)-1);
            if(!in_array($index, $pilihan)) $pilihan[] = $index;
        }

        $now = new DateTime();
        $end_time = clone $now;
        $end_time->modify("+10 minutes");

        foreach($pilihan as $i){
            $random_file = $files[$i];
            $image_url = str_replace(__DIR__, "https://botspacemen.site", $random_file);
            $caption = "🎴 Prediksi Mahjong untuk username: *{$username}*\n🕒 Main jam: ".$now->format("H:i")." - ".$end_time->format("H:i")."\n⚠️ Pola hanya berlaku 10 menit";
            kirimGambar($chat_id, $image_url, $caption);
        }
    } else {
        kirimPesan($chat_id, "⚠️ Folder gambar kosong!");
    }
}

// Fungsi kirim tombol refresh
function kirimRefreshButton($chat_id){
    global $API_URL;
    $inline_keyboard = [
        "inline_keyboard" => [
            [["text" => "Refresh Result", "callback_data" => "refresh"]]
        ]
    ];
    $reply = [
        "chat_id" => $chat_id,
        "text" => "🔄 Klik tombol ini untuk mendapatkan hasil baru (maks 3 jam sekali).",
        "reply_markup" => json_encode($inline_keyboard)
    ];
    file_get_contents($API_URL . "sendMessage?" . http_build_query($reply));
}

// Fungsi kirim tombol ubah username
function kirimUbahUsernameButton($chat_id){
    global $API_URL;
    $inline_keyboard = [
        "inline_keyboard" => [
            [["text" => "Ubah Username", "callback_data" => "ubah_username"]]
        ]
    ];
    $reply = [
        "chat_id" => $chat_id,
        "text" => "✏️ Jika ingin mengganti username, klik tombol di bawah.",
        "reply_markup" => json_encode($inline_keyboard)
    ];
    file_get_contents($API_URL . "sendMessage?" . http_build_query($reply));
}

// Fungsi kirim pesan
function kirimPesan($chat_id, $text){
    global $API_URL;
    $reply = [
        "chat_id" => $chat_id,
        "text" => $text,
        "parse_mode" => "Markdown"
    ];
    file_get_contents($API_URL . "sendMessage?" . http_build_query($reply));
}

// Fungsi kirim gambar
function kirimGambar($chat_id, $url, $caption=""){
    global $API_URL;
    $reply = [
        "chat_id" => $chat_id,
        "photo" => $url,
        "caption" => $caption,
        "parse_mode" => "Markdown"
    ];
    file_get_contents($API_URL . "sendPhoto?" . http_build_query($reply));
}
?>
